﻿using System.ComponentModel.DataAnnotations;
using System.Text.Json.Serialization;

namespace Model;

public class ProductProperty 
{
    public ProductProperty()
    {
        FieldType = Model.FieldType.Text;
    }

    [JsonPropertyName("type")]
    public FieldType? FieldType { get; set; }

    [Required(ErrorMessage = Product.RequiredErrorMessage)]
    [JsonPropertyName("key")]
    public string? Key { get; set; }

    [JsonPropertyName("value")]
    public string? Value { get; set; }
    
    [JsonIgnore]
    public bool IsDeleted { get; set; }
}
